/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.advancement.criterion;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.colossalchests.block.ChestMaterial;
import org.cyclops.cyclopscore.advancement.criterion.ICriterionInstanceTestable;

public class ChestFormedTrigger
extends SimpleCriterionTrigger<Instance> {
    private final ResourceLocation ID = new ResourceLocation("colossalchests", "chest_formed");

    public ChestFormedTrigger() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public ResourceLocation m_7295_() {
        return this.ID;
    }

    public Instance createInstance(JsonObject json, EntityPredicate.Composite entityPredicate, DeserializationContext conditionsParser) {
        ChestMaterial material = null;
        JsonElement element = json.get("material");
        if (element != null && !element.isJsonNull()) {
            String materialString = element.getAsString();
            try {
                material = Objects.requireNonNull(ChestMaterial.valueOf(materialString), "Could not find a chest material by name " + materialString);
            }
            catch (IllegalArgumentException e) {
                throw new JsonSyntaxException("Could not find a colossal chest material by name " + materialString + ". Allowed values: " + ChestMaterial.VALUES.stream().map(ChestMaterial::getName).collect(Collectors.toList()));
            }
        }
        Integer minimumSize = null;
        JsonElement elementSize = json.get("minimumSize");
        if (elementSize != null && !elementSize.isJsonNull()) {
            minimumSize = GsonHelper.m_13897_((JsonElement)elementSize, (String)"minimumSize");
        }
        return new Instance(this.m_7295_(), entityPredicate, material, minimumSize);
    }

    public void test(ServerPlayer player, ChestMaterial material, int size) {
        this.m_66234_(player, instance -> instance.test(player, (Pair<ChestMaterial, Integer>)Pair.of((Object)((Object)material), (Object)size)));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance
    implements ICriterionInstanceTestable<Pair<ChestMaterial, Integer>> {
        private final ChestMaterial material;
        private final Integer minimumSize;

        public Instance(ResourceLocation criterionIn, EntityPredicate.Composite player, @Nullable ChestMaterial material, @Nullable Integer minimumSize) {
            super(criterionIn, player);
            this.material = material;
            this.minimumSize = minimumSize;
        }

        public boolean test(ServerPlayer player, Pair<ChestMaterial, Integer> data) {
            return !(this.material != null && this.material != data.getLeft() || this.minimumSize != null && this.minimumSize > (Integer)data.getRight());
        }
    }
}

